<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Vtours\TTXmlWebService\Service\HotelList;

use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;
use Vtours\TTXmlWebService\Model\Request\SearchEngineHotelListRQ;
use Vtours\TTXmlWebService\Service\HotelList\Mapper;
use Vtours\TTXmlWebService\Service\MappingHelper\GeneralMappingHelper;


/**
 * Class MapperTest
 *
 * @package Tests\Vtours\TTXmlWebService\Service\HotelList
 */
class MapperTest extends TestCase
{
    public function testMapRequestByRegion()
    {
        $mapper = new Mapper();
        $generalMappingHelper = new GeneralMappingHelper();

        $request = include __DIR__ . '/TopRegionIdRequestData.php';
        $search = $generalMappingHelper->mapSearchEngineRequest($request);

        $requestModel = $mapper->mapRequestByRegion($request, $search);

        $this->assertInstanceOf(SearchEngineHotelListRQ::class, $requestModel);
        $this->assertSame($request['code'], $requestModel->getSelection()->getRegionIds());
    }

    public function testSerializationXml()
    {
        $mapper = new Mapper();
        $generalMappingHelper = new GeneralMappingHelper();

        $request = include __DIR__ . '/TopRegionIdRequestData.php';
        $search = $generalMappingHelper->mapSearchEngineRequest($request);

        $requestModel = $mapper->mapRequestByRegion($request, $search);

        $serializer = SerializerBuilder::create()->build();
        $xml = $serializer->serialize($requestModel, 'xml');

        $removeString = [
            '/<TravelDateSpan>/',
            '/<\/TravelDateSpan>/i',
            '/\s<DepartureDate>(.*?)<\/DepartureDate>\s/i',
            '/\s<ReturnDate>(.*?)<\/ReturnDate>\s/i',
            '/timestamp=\"(.*?)\"/i'
        ];
        $response = preg_replace($removeString, '', $xml);
        $this->assertXmlStringEqualsXmlString(file_get_contents(__DIR__ . '\SearchEngineHotelListRequest.xml'), $response);
    }
}
