<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\WeatherResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ValueOfMonth
 *
 * @package Vtours\TTXmlWebService\Model\Response\WeatherResponse
 */
class ValueOfMonth
{
    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\Type("int")
     * @Serializer\SerializedName("Month")
     */
    private $month;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("ValueOfMonth")
     */
    private $valueOfMonth;

    /**
     * @return int
     */
    public function getMonth()
    {
        return $this->month;
    }

    /**
     * @param int $month
     *
     * @return ValueOfMonth
     */
    public function setMonth($month)
    {
        $this->month = $month;

        return $this;
    }

    /**
     * @return int
     */
    public function getValueOfMonth()
    {
        return $this->valueOfMonth;
    }

    /**
     * @param int $valueOfMonth
     *
     * @return ValueOfMonth
     */
    public function setValueOfMonth($valueOfMonth)
    {
        $this->valueOfMonth = $valueOfMonth;

        return $this;
    }
}
