<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;

use Vtours\TTXmlWebService\Model\Response\v2\City;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Region
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\City>")
     * @Serializer\SerializedName("City")
     *
     * @var City
     */
    private $city;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("RegionID")
     *
     * @var integer
     */
    private $regionId;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("HotelCount")
     *
     * @var integer
     */
    private $hotelCount;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\City
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\City $city
     */
    public function setCity($city)
    {
        $this->city = $city;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return int
     */
    public function getRegionId()
    {
        return $this->regionId;
    }

    /**
     * @param int $regionId
     */
    public function setRegionId($regionId)
    {
        $this->regionId = $regionId;
    }
    
    /**
     * @return int
     */
    public function getHotelCount()
    {
        return $this->hotelCount;
    }

    /**
     * @param int $hotelCount
     */
    public function setHotelCount($hotelCount)
    {
        $this->hotelCount = $hotelCount;
    }

    
}
