<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;


/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class TourOperator
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TourOperatorCode")
     *
     * @var string
     */
    private $tourOperatorCode;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TourOperatorName")
     *
     * @var string
     */
    private $tourOperatorName;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("TourOperatorImage")
     *
     * @var string
     */
    private $tourOperatorImage;

    /**
     * @return string
     */
    public function getTourOperatorCode()
    {
        return $this->tourOperatorCode;
    }

    /**
     * @param string $tourOperatorCode
     */
    public function setTourOperatorCode($tourOperatorCode)
    {
        $this->tourOperatorCode = $tourOperatorCode;
    }

    /**
     * @return string
     */
    public function getTourOperatorName()
    {
        return $this->tourOperatorName;
    }

    /**
     * @param string $tourOperatorName
     */
    public function setTourOperatorName($tourOperatorName)
    {
        $this->tourOperatorName = $tourOperatorName;
    }

    /**
     * @return string
     */
    public function getTourOperatorImage()
    {
        return $this->tourOperatorImage;
    }

    /**
     * @param string $tourOperatorImage
     */
    public function setTourOperatorImage($tourOperatorImage)
    {
        $this->tourOperatorImage = $tourOperatorImage;
    }
}
