<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;

use Vtours\TTXmlWebService\Model\Response\v2\Region;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class RegionGroup
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\Region>")
     * @Serializer\SerializedName("Region")
     *
     * @var Region
     */
    private $region;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("RegionGroupID")
     *
     * @var integer
     */
    private $regionGroupId;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("HotelCount")
     *
     * @var integer
     */
    private $hotelCount;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\Region
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\Region $region
     */
    public function setRegion($region)
    {
        $this->region = $region;
    }

    /**
     * @return int
     */
    public function getRegionGroupId()
    {
        return $this->regionGroupId;
    }

    /**
     * @param int $regionGroupId
     */
    public function setRegionGroupId($regionGroupId)
    {
        $this->regionGroupId = $regionGroupId;
    }

    /**
     * @return int
     */
    public function getHotelCount()
    {
        return $this->hotelCount;
    }

    /**
     * @param int $hotelCount
     */
    public function setHotelCount($hotelCount)
    {
        $this->hotelCount = $hotelCount;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }
}
