<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;


/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class RegionGroups
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\RegionGroup>")
     * @Serializer\SerializedName("RegionGroup")
     *
     * @var RegionGroup
     */
    private $regionGroup;

    /**
     * @return RegionGroup
     */
    public function getRegionGroup()
    {
        return $this->regionGroup;
    }

    /**
     * @param RegionGroup $regionGroup
     */
    public function setRegionGroup($regionGroup)
    {
        $this->regionGroup = $regionGroup;
    }

}
