<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary;


use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\Metadata;
use Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Country;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Countries
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\GeoDictionary\Country>")
     * @Serializer\SerializedName("Country")
     *
     * @var array|Country[]
     */
    private $country;

    /**
     * @return array|Country[]
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param array|Country[] $country
     */
    public function setCountry($country)
    {
        $this->country = $country;
    }
}
