<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

/**
 * Created by PhpStorm.
 * User: j.kretz
 * Date: 22.06.2017
 * Time: 11:50
 */

namespace Test\Vtours\TTXmlWebService;


use JMS\Serializer\Serializer;
use PHPUnit\Framework\TestCase;
use Vtours\TTXmlWebService\Model\Request\TestRequest;

class TestRequestTest extends TestCase
{
    /**
     * @var Serializer
     */
    private $serializer;

    public function setUp()
    {
        $this->serializer = \JMS\Serializer\SerializerBuilder::create()->build();

    }

    public function testMinDays()
    {
        $test = new TestRequest();
        $output = <<<'TAG'
<?xml version="1.0" encoding="UTF-8"?>
<root>
  <MinDays>4</MinDays>
  <MaxDays>8</MaxDays>
</root>

TAG;


        $test->setMinDays(4);
        $test->setMaxDays(8);


        $test = $this->serializer->serialize($test, 'xml');
        $this->assertEquals($output, $test);
    }
}