<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Vtours\TTXmlWebService\Service\OfferList;

use JMS\Serializer\SerializerBuilder;
use PHPUnit\Framework\TestCase;
use Vtours\TTXmlWebService\Model\Request\SearchEngineOfferListRQ;
use Vtours\TTXmlWebService\Service\MappingHelper\GeneralMappingHelper;
use Vtours\TTXmlWebService\Service\OfferList\Mapper;


/**
 * Class MapperTest
 *
 * @package Tests\Vtours\TTXmlWebService\Service\OfferList
 */
class MapperTest extends TestCase
{
    public function testMapRequestByHotelCode()
    {
        $mapper = new Mapper();
        $generalMappingHelper = new GeneralMappingHelper();

        $request = include __DIR__ . '/IffCodeRequestData.php';
        $search = $generalMappingHelper->mapSearchEngineRequest($request);

        $requestModel = $mapper->mapRequestByHotelCode($request, $search);

        $this->assertInstanceOf(SearchEngineOfferListRQ::class, $requestModel);
        $this->assertSame($request['code'], $requestModel->getSelection()->getHotelSelection()->getObjectId()->getValue());
    }

    public function testSerializationXml()
    {
        $mapper = new Mapper();
        $generalMappingHelper = new GeneralMappingHelper();

        $request = include __DIR__ . '/IffCodeRequestData.php';
        $search = $generalMappingHelper->mapSearchEngineRequest($request);

        $requestModel = $mapper->mapRequestByHotelCode($request, $search);

        $serializer = SerializerBuilder::create()->build();
        $xml = $serializer->serialize($requestModel, 'xml');

        $removeString = [
            '/<TravelDateSpan>/',
            '/<\/TravelDateSpan>/i',
            '/\s<DepartureDate>(.*?)<\/DepartureDate>\s/i',
            '/\s<ReturnDate>(.*?)<\/ReturnDate>\s/i',
            '/timestamp=\"(.*?)\"/i'
        ];
        $response = preg_replace($removeString, '', $xml);
        $this->assertXmlStringEqualsXmlString(file_get_contents(__DIR__ . '\SearchEngineOfferListRequest.xml'), $response);
    }
}
