<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class SearchEngineRegionTreeRS
 *
 * @package Vtours\TTXmlWebService\Model\Response
 * @Serializer\XmlRoot("SearchEngineRegionTreeRS")
 * @Serializer\XmlNamespace(uri="http://traveltainment.de/middleware/xml/SearchEngineRegionTreeRS", prefix ="t")
 */
class SearchEngineRegionTreeRS
{
    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\Type("int")
     * @Serializer\SerializedName("ClientSessionId")
     */
    private $clientSessionID;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CorrelationsID")
     */
    private $correlationsID;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LanguageCode")
     */
    private $languageCode;

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\Type("int")
     * @Serializer\SerializedName("ProcessingTime")
     */
    private $processingTime = 0;

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\Type("int")
     * @Serializer\SerializedName("SessionID")
     */
    private $sessionID;

    /**
     * @var bool
     * @Serializer\XmlAttribute()
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("Success")
     */
    private $success = false;

    /**
     * @var string
     * @Serializer\XmlAttribute()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Target")
     */
    private $target;

    /**
     * @var \DateTime
     * @Serializer\XmlAttribute()
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:s'>")
     * @Serializer\SerializedName("Timestamp")
     */
    private $timestamp;

    /**
     * @var int
     * @Serializer\XmlAttribute()
     * @Serializer\Type("int")
     * @Serializer\SerializedName("TrackingID")
     */
    private $trackingID;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("CID")
     */
    private $cid;

    /**
     * @var string
     * @Serializer\Type("string")
     * @Serializer\SerializedName("InfoMessage")
     */
    private $infoMessage;

    /**
     * @var Regions
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\Regions")
     * @Serializer\SerializedName("Regions")
     */
    private $regions;

    /**
     * @return int
     */
    public function getClientSessionID()
    {
        return $this->clientSessionID;
    }

    /**
     * @param int $clientSessionID
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setClientSessionID($clientSessionID)
    {
        $this->clientSessionID = $clientSessionID;

        return $this;
    }

    /**
     * @return string
     */
    public function getCorrelationsID()
    {
        return $this->correlationsID;
    }

    /**
     * @param string $correlationsID
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setCorrelationsID($correlationsID)
    {
        $this->correlationsID = $correlationsID;

        return $this;
    }

    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }

    /**
     * @param string $languageCode
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;

        return $this;
    }

    /**
     * @return int
     */
    public function getProcessingTime()
    {
        return $this->processingTime;
    }

    /**
     * @param int $processingTime
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setProcessingTime($processingTime)
    {
        $this->processingTime = $processingTime;

        return $this;
    }

    /**
     * @return int
     */
    public function getSessionID()
    {
        return $this->sessionID;
    }

    /**
     * @param int $sessionID
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setSessionID($sessionID)
    {
        $this->sessionID = $sessionID;

        return $this;
    }

    /**
     * @return bool
     */
    public function isSuccess()
    {
        return $this->success;
    }

    /**
     * @param bool $success
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setSuccess($success)
    {
        $this->success = $success;

        return $this;
    }

    /**
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * @param string $target
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setTarget($target)
    {
        $this->target = $target;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }

    /**
     * @param \DateTime $timestamp
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setTimestamp($timestamp)
    {
        $this->timestamp = $timestamp;

        return $this;
    }

    /**
     * @return int
     */
    public function getTrackingID()
    {
        return $this->trackingID;
    }

    /**
     * @param int $trackingID
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setTrackingID($trackingID)
    {
        $this->trackingID = $trackingID;

        return $this;
    }

    /**
     * @return int
     */
    public function getCid()
    {
        return $this->cid;
    }

    /**
     * @param int $cid
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setCid($cid)
    {
        $this->cid = $cid;

        return $this;
    }

    /**
     * @return string
     */
    public function getInfoMessage()
    {
        return $this->infoMessage;
    }

    /**
     * @param string $infoMessage
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setInfoMessage($infoMessage)
    {
        $this->infoMessage = $infoMessage;

        return $this;
    }

    /**
     * @return Regions
     */
    public function getRegions()
    {
        return $this->regions;
    }

    /**
     * @param Regions $regions
     *
     * @return SearchEngineRegionTreeRS
     */
    public function setRegions($regions)
    {
        $this->regions = $regions;

        return $this;
    }
}
