<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class HotelGeoPoint
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("float")
     * @Serializer\SerializedName("Longitude")
     *
     * @var float
     */
    private $longitude;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("float")
     * @Serializer\SerializedName("Latitude")
     *
     * @var float
     */
    private $latitude;

    /**
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }

    /**
     * @param float $longitude
     */
    public function setLongitude($longitude)
    {
        $this->longitude = $longitude;
    }

    /**
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }

    /**
     * @param float $latitude
     */
    public function setLatitude($latitude)
    {
        $this->latitude = $latitude;
    }
}
