<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\MeanRating;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class MeanRatings
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("array<Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\MeanRating>")
     * @Serializer\SerializedName("MeanRating")
     *
     * @var MeanRating
     */
    private $meanRating;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\MeanRating
     */
    public function getMeanRating()
    {
        return $this->meanRating;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary\MeanRating $meanRating
     */
    public function setMeanRating($meanRating)
    {
        $this->meanRating = $meanRating;
    }
}
