<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\FlightDeparture;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\FlightArrival;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\Airline;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class OutboundFlight
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\FlightDeparture")
     * @Serializer\SerializedName("FlightDeparture")
     *
     * @var FlightDeparture
     */
    private $flightDeparture;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\FlightArrival")
     * @Serializer\SerializedName("FlightArrival")
     *
     * @var FlightArrival
     */
    private $flightArrival;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("FlightDuration")
     *
     * @var int
     */
    private $flightDuration;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("integer")
     * @Serializer\SerializedName("AverageFlightDuration")
     *
     * @var int
     */
    private $averageFlightDuration;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("DirectFlightAssumed")
     *
     * @var bool
     */
    private $directFlightAssumed;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\Airline")
     * @Serializer\SerializedName("Airline")
     *
     * @var Airline
     */
    private $airline;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\Offers\FlightDeparture
     */
    public function getFlightDeparture()
    {
        return $this->flightDeparture;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\Offers\FlightDeparture $flightDeparture
     */
    public function setFlightDeparture($flightDeparture)
    {
        $this->flightDeparture = $flightDeparture;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\Offers\FlightArrival
     */
    public function getFlightArrival()
    {
        return $this->flightArrival;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\Offers\FlightArrival $flightArrival
     */
    public function setFlightArrival($flightArrival)
    {
        $this->flightArrival = $flightArrival;
    }

    /**
     * @return int
     */
    public function getFlightDuration()
    {
        return $this->flightDuration;
    }

    /**
     * @param int $flightDuration
     */
    public function setFlightDuration($flightDuration)
    {
        $this->flightDuration = $flightDuration;
    }

    /**
     * @return int
     */
    public function getAverageFlightDuration()
    {
        return $this->averageFlightDuration;
    }

    /**
     * @param int $averageFlightDuration
     */
    public function setAverageFlightDuration($averageFlightDuration)
    {
        $this->averageFlightDuration = $averageFlightDuration;
    }

    /**
     * @return bool
     */
    public function isDirectFlightAssumed()
    {
        return $this->directFlightAssumed;
    }

    /**
     * @param bool $directFlightAssumed
     */
    public function setDirectFlightAssumed($directFlightAssumed)
    {
        $this->directFlightAssumed = $directFlightAssumed;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\Offers\Airline
     */
    public function getAirline()
    {
        return $this->airline;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\Offers\Airline $airline
     */
    public function setAirline($airline)
    {
        $this->airline = $airline;
    }
}
