<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\v2\OfferFilters;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class AccomFilter
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\OfferFilters\AccomSelectors")
     * @Serializer\SerializedName("AccomSelectors")
     *
     * @var AccomSelectors
     */
    private $accomSelectors;

    /**
     * @return AccomSelectors
     */
    public function getAccomSelectors()
    {
        return $this->accomSelectors;
    }

    /**
     * @param AccomSelectors $accomSelectors
     */
    public function setAccomSelectors($accomSelectors)
    {
        $this->accomSelectors = $accomSelectors;
    }

}
