<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class InboundFlight
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("FlightDeparture")
     *
     * @var string
     */
    private $flightDeparture;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("CurrencyCode")
     *
     * @var string
     */
    private $flightArrival;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("FlightDuration")
     *
     * @var string
     */
    private $flightDuration;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AverageFlightDuration")
     *
     * @var string
     */
    private $averageFlightDuration;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("boolean")
     * @Serializer\SerializedName("DirectFlightAssumed")
     *
     * @var bool
     */
    private $directFlightAssumed;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Airline")
     * @var string
     */
    private $airline;

    /**
     * @return string
     */
    public function getFlightDeparture()
    {
        return $this->flightDeparture;
    }

    /**
     * @param string $flightDeparture
     */
    public function setFlightDeparture($flightDeparture)
    {
        $this->flightDeparture = $flightDeparture;
    }

    /**
     * @return string
     */
    public function getFlightArrival()
    {
        return $this->flightArrival;
    }

    /**
     * @param string $flightArrival
     */
    public function setFlightArrival($flightArrival)
    {
        $this->flightArrival = $flightArrival;
    }

    /**
     * @return string
     */
    public function getFlightDuration()
    {
        return $this->flightDuration;
    }

    /**
     * @param string $flightDuration
     */
    public function setFlightDuration($flightDuration)
    {
        $this->flightDuration = $flightDuration;
    }

    /**
     * @return string
     */
    public function getAverageFlightDuration()
    {
        return $this->averageFlightDuration;
    }

    /**
     * @param string $averageFlightDuration
     */
    public function setAverageFlightDuration($averageFlightDuration)
    {
        $this->averageFlightDuration = $averageFlightDuration;
    }

    /**
     * @return bool
     */
    public function isDirectFlightAssumed()
    {
        return $this->directFlightAssumed;
    }

    /**
     * @param bool $directFlightAssumed
     */
    public function setDirectFlightAssumed($directFlightAssumed)
    {
        $this->directFlightAssumed = $directFlightAssumed;
    }

    /**
     * @return string
     */
    public function getAirline()
    {
        return $this->airline;
    }

    /**
     * @param string $airline
     */
    public function setAirline($airline)
    {
        $this->airline = $airline;
    }
}
