<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Vtours\TTXmlWebService\Service\HotelList;

use Vtours\TTXmlWebService\Model\DatenAngebotRequestModel;
use Vtours\TTXmlWebService\Model\Request\SearchEngineHotelListRQ;
use Vtours\TTXmlWebService\Model\Request\SelectionRequest\Selection;
use Vtours\TTXmlWebService\Service\MappingHelper\GeneralMappingHelper;

/**
 * Class Mapper
 *
 * @package Vtours\TTXmlWebService\Service\HotelList
 */
class Mapper
{
    /**
     * @var GeneralMappingHelper
     */
    private $generalMappingHelper;

    /**
     * Mapper constructor.
     *
     * @param GeneralMappingHelper $generalMappingHelper
     */
    public function __construct(GeneralMappingHelper $generalMappingHelper)
    {
        $this->generalMappingHelper = $generalMappingHelper;
    }

    /**
     * @param DatenAngebotRequestModel $request
     *
     * @return SearchEngineHotelListRQ
     */
    public function mapRequestByRegion(DatenAngebotRequestModel $request)
    {
        $requestSearchModel = $this->generalMappingHelper->mapSearchEngineRequest($request);

        $selection = new Selection();
        $selection->setRegionIds($request->getCode());

        $searchEngineHotelListRQ = new SearchEngineHotelListRQ();
        $searchEngineHotelListRQ
            ->setSelection($selection)
            ->setSearch($requestSearchModel);

        return $searchEngineHotelListRQ;
    }
}
