<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\v2;

use JMS\Serializer\Annotation as Serializer;
use Vtours\TTXmlWebService\Model\Request\v2\AccommodationOffersRQ\AccommodationOfferRQ;


/**
 * @Serializer\ExclusionPolicy("all")
 */
class AccommodationOfferMainRQ
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\AccommodationOffersRQ\AccommodationOfferRQ")
     * @Serializer\SerializedName("AccommodationOffersRQ")
     *
     * @var AccommodationOfferRQ
     */
    private $accommodationOfferRQ;

    /**
     * @return AccommodationOfferRQ
     */
    public function getAccommodationOfferRQ()
    {
        return $this->accommodationOfferRQ;
    }

    /**
     * @param AccommodationOfferRQ $accommodationOfferRQ
     */
    public function setAccommodationOfferRQ(AccommodationOfferRQ $accommodationOfferRQ)
    {
        $this->accommodationOfferRQ = $accommodationOfferRQ;
    }
}
