<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Request\v2;

use JMS\Serializer\Annotation as Serializer;
use  Vtours\TTXmlWebService\Model\Request\v2\InventoryDataForPackageRQ;


/**
 * @Serializer\ExclusionPolicy("all")
 */
class InventoryDataForPackageMainRQ
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Request\v2\InventoryDataForPackageRQ")
     * @Serializer\SerializedName("InventoryDataForPackageRQ")
     *
     * @var InventoryDataForPackageRQ
     */
    private $inventoryDataForPackageRQ;

    /**
     * @return \Vtours\TTXmlWebService\Model\Request\v2\InventoryDataForPackageRQ
     */
    public function getInventoryDataForPackageRQ()
    {
        return $this->inventoryDataForPackageRQ;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Request\v2\InventoryDataForPackageRQ $inventoryDataForPackageRQ
     */
    public function setInventoryDataForPackageRQ($inventoryDataForPackageRQ)
    {
        $this->inventoryDataForPackageRQ = $inventoryDataForPackageRQ;
    }
    
    
}
