<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */
namespace Vtours\TTXmlWebService\Model\Request\v2\OfferFilters;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\ExclusionPolicy("all")
 */
class DepartureStationFilter
{
    /**
     * @Serializer\Expose()
     * @Serializer\SerializedName("StationCodes")
     * @Serializer\Type("array")
     *
     * @var array
     */
    private $stationCodes;

    /**
     * @return array
     */
    public function getStationCodes()
    {
        return $this->stationCodes;
    }

    /**
     * @param array $stationCodes
     */
    public function setStationCodes($stationCodes)
    {
        $this->stationCodes = $stationCodes;
    }
}
