<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 *   @copyright 2017 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\FlightResponse;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class BaggageAllowance
 *
 * @package Vtours\TTXmlWebService\Model\Response\FlightResponse
 */
class BaggageAllowance
{

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("MaxBags")
     */
    private $maxBags;

    /**
     * @var int
     * @Serializer\Type("int")
     * @Serializer\SerializedName("MaxWeight")
     */
    private $maxWeight;

    /**
     * @return int
     */
    public function getMaxBags()
    {
        return $this->maxBags;
    }

    /**
     * @param int $maxBags
     *
     * @return BaggageAllowance
     */
    public function setMaxBags($maxBags)
    {
        $this->maxBags = $maxBags;

        return $this;
    }

    /**
     * @return int
     */
    public function getMaxWeight()
    {
        return $this->maxWeight;
    }

    /**
     * @param int $maxWeight
     *
     * @return BaggageAllowance
     */
    public function setMaxWeight($maxWeight)
    {
        $this->maxWeight = $maxWeight;

        return $this;
    }
}
