<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\HotelDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class HotelImages
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Thumbnail")
     *
     * @var string
     */
    private $thumbNails;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("MediumImage")
     *
     * @var string
     */
    private $mediumImage;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("LargeImage")
     *
     * @var string
     */
    private $largeImage;

    /**
     * @return string
     */
    public function getThumbNails()
    {
        return $this->thumbNails;
    }

    /**
     * @param string $thumbNails
     */
    public function setThumbNails($thumbNails)
    {
        $this->thumbNails = $thumbNails;
    }

    /**
     * @return string
     */
    public function getMediumImage()
    {
        return $this->mediumImage;
    }

    /**
     * @param string $mediumImage
     */
    public function setMediumImage($mediumImage)
    {
        $this->mediumImage = $mediumImage;
    }

    /**
     * @return string
     */
    public function getLargeImage()
    {
        return $this->largeImage;
    }

    /**
     * @param string $largeImage
     */
    public function setLargeImage($largeImage)
    {
        $this->largeImage = $largeImage;
    }

}
