<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Airline
{

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AirlineCode")
     *
     * @var string
     */
    private $airlineCode;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AirlineName")
     *
     * @var string
     */
    private $averageFlightDuration;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("AirlineImage")
     *
     * @var string
     */
    private $airlineImage;

    /**
     * @return string
     */
    public function getAirlineCode()
    {
        return $this->airlineCode;
    }

    /**
     * @param string $airlineCode
     */
    public function setAirlineCode($airlineCode)
    {
        $this->airlineCode = $airlineCode;
    }

    /**
     * @return string
     */
    public function getAverageFlightDuration()
    {
        return $this->averageFlightDuration;
    }

    /**
     * @param string $averageFlightDuration
     */
    public function setAverageFlightDuration($averageFlightDuration)
    {
        $this->averageFlightDuration = $averageFlightDuration;
    }

    /**
     * @return string
     */
    public function getAirlineImage()
    {
        return $this->airlineImage;
    }

    /**
     * @param string $airlineImage
     */
    public function setAirlineImage($airlineImage)
    {
        $this->airlineImage = $airlineImage;
    }
}
