<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\DepartureAirportRef;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class FlightDeparture
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\DepartureAirportRef")
     * @Serializer\SerializedName("DepartureAirportRef")
     *
     * @var DepartureAirportRef
     */
    private $departureAirportRef;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("DepartureDate")
     *
     * @var string
     */
    private $departureDate;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("DepartureTime")
     *
     * @var string
     */
    private $departureTime;

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\Offers\DepartureAirportRef
     */
    public function getDepartureAirportRef()
    {
        return $this->departureAirportRef;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\Offers\DepartureAirportRef $departureAirportRef
     */
    public function setDepartureAirportRef($departureAirportRef)
    {
        $this->departureAirportRef = $departureAirportRef;
    }

    /**
     * @return string
     */
    public function getDepartureDate()
    {
        return $this->departureDate;
    }

    /**
     * @param string $departureDate
     */
    public function setDepartureDate($departureDate)
    {
        $this->departureDate = $departureDate;
    }

    /**
     * @return string
     */
    public function getDepartureTime()
    {
        return $this->departureTime;
    }

    /**
     * @param string $departureTime
     */
    public function setDepartureTime($departureTime)
    {
        $this->departureTime = $departureTime;
    }

}
