<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\Offers;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

use Vtours\TTXmlWebService\Model\Response\v2\Offers\Package;
use Vtours\TTXmlWebService\Model\Response\v2\Offers\Accommodation;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class OfferServices
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\Package")
     * @Serializer\SerializedName("Package")
     *
     * @var Package
     */
    private $package;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\Offers\Accommodation")
     * @Serializer\SerializedName("Accommodation")
     *
     * @var Accommodation
     */
    private $accommodation;

    /**
     * @return Package
     */
    public function getPackage()
    {
        return $this->package;
    }

    /**
     * @param Package $package
     */
    public function setPackage($package)
    {
        $this->package = $package;
    }

    /**
     * @return \Vtours\TTXmlWebService\Model\Response\v2\Offers\Accommodation
     */
    public function getAccommodation()
    {
        return $this->accommodation;
    }

    /**
     * @param \Vtours\TTXmlWebService\Model\Response\v2\Offers\Accommodation $accommodation
     */
    public function setAccommodation($accommodation)
    {
        $this->accommodation = $accommodation;
    }
}
