<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2022 Lifestyle Webconsulting GmbH
 */

namespace Vtours\TTXmlWebService\Model\Response\v2\StationDictionary;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\MetaData;

use Vtours\TTXmlWebService\Model\Response\v2\StationDictionary\StationLocationRef;

/**
 * @Serializer\AccessType(type=Metadata\PropertyMetadata::ACCESS_TYPE_PUBLIC_METHOD)
 * @Serializer\ExclusionPolicy(Serializer\ExclusionPolicy::ALL)
 */
class Station
{
    /**
     * @Serializer\Expose()
     * @Serializer\Type("Vtours\TTXmlWebService\Model\Response\v2\StationDictionary\StationLocationRef")
     * @Serializer\SerializedName("StationLocationRef")
     *
     * @var StationLocationRef
     */
    private $StationLocationRef;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("Name")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("StationCode")
     *
     * @var string
     */
    private $stationCode;

    /**
     * @Serializer\Expose()
     * @Serializer\Type("string")
     * @Serializer\SerializedName("StationType")
     *
     * @var string
     */
    private $stationType;

    /**
     * @return StationLocationRef
     */
    public function getStationLocationRef()
    {
        return $this->StationLocationRef;
    }

    /**
     * @param StationLocationRef $StationLocationRef
     */
    public function setStationLocationRef($StationLocationRef)
    {
        $this->StationLocationRef = $StationLocationRef;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getStationCode()
    {
        return $this->stationCode;
    }

    /**
     * @param string $stationCode
     */
    public function setStationCode($stationCode)
    {
        $this->stationCode = $stationCode;
    }

    /**
     * @return string
     */
    public function getStationType()
    {
        return $this->stationType;
    }

    /**
     * @param string $stationType
     */
    public function setStationType($stationType)
    {
        $this->stationType = $stationType;
    }
}
