<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Vmix\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class VmixDataWrapper
 * @package Vtours\Vmix\Model
 */
class Request
{
    /**
     * @var integer
     *
     * @Serializer\SerializedName("booking_no")
     * @Serializer\Type("integer")
     */
    private $bookingId;

    /**
     * Concenation of Booking ID and a static string
     *
     * @var string
     */
    private $checkMd5;

    /**
     * @var VmixDataInterface
     */
    private $vmixData;

    /**
     * @return int
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }

    /**
     * @param int $bookingId
     * @return Request
     */
    public function setBookingId($bookingId)
    {
        $this->bookingId = $bookingId;
        return $this;
    }

    /**
     * @return string
     */
    public function getCheckMd5()
    {
        return $this->checkMd5;
    }

    /**
     * @param string $checkMd5
     * @return Request
     */
    public function setCheckMd5($checkMd5)
    {
        $this->checkMd5 = $checkMd5;
        return $this;
    }

    /**
     * @return VmixDataInterface
     */
    public function getVmixData()
    {
        return $this->vmixData;
    }

    /**
     * @param VmixData $vmixData
     * @return Request
     */
    public function setVmixData($vmixData)
    {
        $this->vmixData = $vmixData;
        return $this;
    }

    public function asArray()
    {
        return array(
            "booking_no" => $this->bookingId,
            "chck" => md5($this->checkMd5),
            "VmixData" => $this->vmixData->asArray()
        );
    }
}