<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Vmix\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class VmixData
 * @package App\Service\VmixSyncTEMP\Model
 */
class VmixData implements VmixDataInterface
{
    /**
     * true = payed, false = unpaid
     *
     * @var boolean
     *
     * @Serializer\SerializedName("balancepayment_on")
     * @Serializer\Type("boolean")
     */
    private $balancePaymentStatus;

    /**
     * @var \DateTime
     *
     * @Serializer\SerializedName("balancepayment_date")
     * @Serializer\Type("DateTime<'Y-m-d H:i:s'>")
     */
    private $balancePaymentDate;

    /**
     * @var string
     *
     * @Serializer\SerializedName("balancepayment_who")
     * @Serializer\Type("string")
     */
    private $balancePaymentUser;

    /**
     * true = payed, false = unpaid
     *
     * @var boolean
     *
     * @Serializer\SerializedName("prepayment_on")
     * @Serializer\Type("boolean")
     */
    private $prePaymentStatus;

    /**
     * @var \DateTime
     *
     * @Serializer\SerializedName("prepayment_date")
     * @Serializer\Type("DateTime<'Y-m-d H:i:s'>")
     */
    private $prePaymentDate;

    /**
     * @var string
     *
     * @Serializer\SerializedName("prepayment_who")
     * @Serializer\Type("string")
     */
    private $prePaymentUser;

    /**
     * @var string
     *
     * @Serializer\SerializedName("bemerkung")
     * @Serializer\Type("string")
     */
    private $internalComment;

    /**
     * @return bool
     */
    public function isBalancePaymentStatus()
    {
        return $this->balancePaymentStatus;
    }

    /**
     * @param bool $balancePaymentStatus
     * @return VmixData
     */
    public function setBalancePaymentStatus($balancePaymentStatus)
    {
        $this->balancePaymentStatus = $balancePaymentStatus;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBalancePaymentDate()
    {
        return $this->balancePaymentDate;
    }

    /**
     * @param \DateTime $balancePaymentDate
     * @return VmixData
     */
    public function setBalancePaymentDate($balancePaymentDate)
    {
        $this->balancePaymentDate = $balancePaymentDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getBalancePaymentUser()
    {
        return $this->balancePaymentUser;
    }

    /**
     * @param string $balancePaymentUser
     * @return VmixData
     */
    public function setBalancePaymentUser($balancePaymentUser)
    {
        $this->balancePaymentUser = $balancePaymentUser;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPrePaymentStatus()
    {
        return $this->prePaymentStatus;
    }

    /**
     * @param bool $prePaymentStatus
     * @return VmixData
     */
    public function setPrePaymentStatus($prePaymentStatus)
    {
        $this->prePaymentStatus = $prePaymentStatus;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getPrePaymentDate()
    {
        return $this->prePaymentDate;
    }

    /**
     * @param \DateTime $prePaymentDate
     * @return VmixData
     */
    public function setPrePaymentDate($prePaymentDate)
    {
        $this->prePaymentDate = $prePaymentDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getPrePaymentUser()
    {
        return $this->prePaymentUser;
    }

    /**
     * @param string $prePaymentUser
     * @return VmixData
     */
    public function setPrePaymentUser($prePaymentUser)
    {
        $this->prePaymentUser = $prePaymentUser;
        return $this;
    }

    /**
     * @return string
     */
    public function getInternalComment()
    {
        return $this->internalComment;
    }

    /**
     * @param string $internalComment
     * @return VmixData
     */
    public function setInternalComment($internalComment)
    {
        $this->internalComment = $internalComment;
        return $this;
    }

    public function asArray()
    {

        $input = array(
            "balancepayment_on" => $this->balancePaymentStatus,
            "balancepayment_date" => $this->balancePaymentDate,
            "balancepayment_who" => $this->balancePaymentUser,
            "prepayment_on" => $this->prePaymentStatus,
            "prepayment_date" => $this->prePaymentDate,
            "prepayment_who" => $this->prePaymentUser,
            "bemerkung" => $this->internalComment
        );

        return array_filter($input, 'strlen');
    }


}