<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Vmix\Service;

use GuzzleHttp\Client;
use Psr\Http\Message\ResponseInterface;
use Vtours\Vmix\Model\Config;
use Vtours\Vmix\Model\Request;
use Vtours\Vmix\Model\VmixData;

/**
 * Class VmixService
 * @package Vtours\Vmix\Service
 */
class VmixService
{
    const CHECK_MD5_SUFFIX = 'vto_mid_office_processing_web_service#001';

    /**
     * @param int $bookingId
     * @param VmixData $vmixData
     * @param Config $config
     * @return bool|ResponseInterface
     */
    public function sendToVmix($bookingId, VmixData $vmixData, Config $config)
    {
        $request = new Request();

        $request
            ->setBookingId($bookingId)
            ->setCheckMd5($request->getBookingId() . static::CHECK_MD5_SUFFIX)
            ->setVmixData($vmixData);

        $response = $this->request($request, $config);

        $xml = simplexml_load_string($response->getBody()->getContents());

        if ((string)$xml->Status === 'OK') {
            return true;
        }

        return false;
    }

    /**
     * @param Request $request
     * @param Config $config
     * @return ResponseInterface
     */
    private function request(Request $request, Config $config)
    {
        $client = $this->buildClient($config);

        $requestData = $request->asArray();

        return $client->post($config->getPath(), [
            "form_params" => [
                'data' => base64_encode(serialize($requestData))
            ]
        ]);
    }

    /**
     * @param Config $config
     * @return Client
     */
    private function buildClient(Config $config)
    {
        return new Client([
            "base_uri" => $config->getBaseUrl(),
            "timeout" => ($config->hasTimeout()) ? $config->getTimeout() : 30
        ]);
    }
}