<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\VmixSync\Model;

use DateTime;

/**
 * Class VmixData
 * @package App\Service\VmixSyncTEMP\Model
 */
class VmixData implements VmixDataInterface
{
    /**
     * true = payed, false = unpaid
     *
     * @var boolean
     *
     * @VmixFieldName("balancepayment_on")
     */
    private $balancePaymentStatus;

    /**
     * @var DateTime
     *
     * @VmixFieldName("balancepayment_date")
     */
    private $balancePaymentDate;

    /**
     * @var string
     *
     * @VmixFieldName("balancepayment_who")
     */
    private $balancePaymentUser;

    /**
     * true = payed, false = unpaid
     *
     * @var boolean
     *
     * @VmixFieldName("prepayment_on")
     */
    private $prePaymentStatus;

    /**
     * @var DateTime
     *
     * @VmixFieldName("prepayment_date")
     */
    private $prePaymentDate;

    /**
     * @var string
     *
     * @VmixFieldName("prepayment_who")
     */
    private $prePaymentUser;

    /**
     * @var string
     *
     * @VmixFieldName("bemerkung")
     */
    private $internalComment;

    /**
     * @return bool
     */
    public function isBalancePaymentStatus()
    {
        return $this->balancePaymentStatus;
    }

    /**
     * @param bool $balancePaymentStatus
     * @return VmixData
     */
    public function setBalancePaymentStatus($balancePaymentStatus)
    {
        $this->balancePaymentStatus = $balancePaymentStatus;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getBalancePaymentDate()
    {
        return $this->balancePaymentDate;
    }

    /**
     * @param DateTime $balancePaymentDate
     * @return VmixData
     */
    public function setBalancePaymentDate($balancePaymentDate)
    {
        $this->balancePaymentDate = $balancePaymentDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getBalancePaymentUser()
    {
        return $this->balancePaymentUser;
    }

    /**
     * @param string $balancePaymentUser
     * @return VmixData
     */
    public function setBalancePaymentUser($balancePaymentUser)
    {
        $this->balancePaymentUser = $balancePaymentUser;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPrePaymentStatus()
    {
        return $this->prePaymentStatus;
    }

    /**
     * @param bool $prePaymentStatus
     * @return VmixData
     */
    public function setPrePaymentStatus($prePaymentStatus)
    {
        $this->prePaymentStatus = $prePaymentStatus;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getPrePaymentDate()
    {
        return $this->prePaymentDate;
    }

    /**
     * @param DateTime $prePaymentDate
     * @return VmixData
     */
    public function setPrePaymentDate($prePaymentDate)
    {
        $this->prePaymentDate = $prePaymentDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getPrePaymentUser()
    {
        return $this->prePaymentUser;
    }

    /**
     * @param string $prePaymentUser
     * @return VmixData
     */
    public function setPrePaymentUser($prePaymentUser)
    {
        $this->prePaymentUser = $prePaymentUser;
        return $this;
    }

    /**
     * @return string
     */
    public function getInternalComment()
    {
        return $this->internalComment;
    }

    /**
     * @param string $internalComment
     * @return VmixData
     */
    public function setInternalComment($internalComment)
    {
        $this->internalComment = $internalComment;
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function asArray()
    {
        return get_object_vars($this);
    }
}
