<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Converter;

use PHPUnit\Framework\TestCase;
use Vtours\VmixSync\Converter\ResponseConverter;
use Vtours\VmixSync\Model;

/**
 * Class ResponseConverterTest
 * @package Converter
 */
class ResponseConverterTest extends TestCase
{
    public function test_convert()
    {
        $body = '<?xml version="1.0" encoding="UTF-8"?><VmixHTTP><TimeStamp>2020-03-12 10:42:23</TimeStamp><ProcessStart>2020-03-12 10:42:23</ProcessStart><ProcessEnd>2020-03-12 10:42:23</ProcessEnd><Status>NOK</Status><Action></Action><Errors><Item>Cannot update xmixbooks!</Item><Item>No booking found for book ID: 123456789</Item></Errors><booking_no>123456789</booking_no></VmixHTTP>';

        $response = ResponseConverter::convert($body);

        self::assertInstanceOf(Model\Response::class, $response);

        self::assertEquals('NOK', $response->getStatus());
    }
}