<?php

use Vtours\VmixSync\Model\Config;
use Vtours\VmixSync\Model\VmixData;
use Vtours\VmixSync\Service\VmixService;

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 *  @copyright 2020 Lifestyle Webconsulting GmbH
 *  @link http://www.life-style.de
 */

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// Usage example below
/// This example won't be successful since the bookind ID does not exist on side of vmix.
/// But like this you can see how this can be used
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function demonstrate_basic_usage()
{
    // You can either create a new instance of VmixService or even better use Dependency Injection
    $vmixService = new VmixService();

    // Now you will need to populate the VmixData Model with your data.
    $vmixData = new VmixData();
    $vmixData
        ->setPrePaymentDate(new \DateTime())
        ->setInternalComment('Lifestyle TEST');

    // Also the configuration is needed, to declare to which vmix the changes should go.
    $config = new Config();
    $config
        ->setBaseUrl("https://ws2testvmix-vto.vtours.de")
        ->setPath("midoffice/index/xmixbooks/?client=vto")
        ->setTimeout(30);

    // Now send the request to vmix.
    $res = $vmixService->syncToVmix(123456789, $vmixData, $config);

    // Test it and view the results :)
    var_dump($res);
}
