<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\VmixSync\Model;

use DateTime;
use Vtours\VmixSync\Model\Response\ErrorItem;

/**
 * Class Response
 * @package Vtours\VmixSync\Model
 */
class Response
{
    /**
     * @var integer
     */
    private $bookingId;

    /**
     * @var string
     */
    private $status;

    /**
     * @var DateTime
     */
    private $timestamp;

    /**
     * @var DateTime
     */
    private $processStart;

    /**
     * @var DateTime
     */
    private $processEnd;

    /**
     * @var array|null
     */
    private $errors;

    /**
     * @return int
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }

    /**
     * @param int $bookingId
     * @return Response
     */
    public function setBookingId($bookingId)
    {
        $this->bookingId = $bookingId;
        return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }

    /**
     * @param DateTime $timestamp
     * @return Response
     */
    public function setTimestamp($timestamp)
    {
        $this->timestamp = $timestamp;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getProcessStart()
    {
        return $this->processStart;
    }

    /**
     * @param DateTime $processStart
     * @return Response
     */
    public function setProcessStart($processStart)
    {
        $this->processStart = $processStart;
        return $this;
    }

    /**
     * @return DateTime
     */
    public function getProcessEnd()
    {
        return $this->processEnd;
    }

    /**
     * @param DateTime $processEnd
     * @return Response
     */
    public function setProcessEnd($processEnd)
    {
        $this->processEnd = $processEnd;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param array|null $errors
     * @return Response
     */
    public function setErrors($errors)
    {
        $this->errors = $errors;
        return $this;
    }
}
