<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Annotation;

use PHPUnit\Framework\TestCase;
use Vtours\VmixSync\Annotation\AnnotationHydrator;
use Vtours\VmixSync\Model\Response;
use Vtours\VmixSync\Model\VmixData;

/**
 * Class AnnotationHydratorTest
 * @package Annotation
 */
class AnnotationHydratorTest extends TestCase
{
    public function test_hydrate()
    {
        $hydratedResults = AnnotationHydrator::hydrate(VmixData::class);

        self::assertEquals('bemerkung', $hydratedResults['internalComment']);
        self::assertEquals('balancepayment_on', $hydratedResults['balancePaymentStatus']);
        self::assertEquals('prepayment_on', $hydratedResults['prePaymentStatus']);

    }

    public function test_hydrate_on_empty()
    {
        $hydratedResults = AnnotationHydrator::hydrate(new Response());

        self::assertEmpty($hydratedResults);
    }
}