<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\VmixSync\Annotation;

use ReflectionException;
use Vtours\VmixSync\Exception\VmixSyncException;

/**
 * Class AnnotationHydrator
 * @package Vtours\VmixSync\Annotation
 */
class AnnotationHydrator
{
    const REGEX_DOCBLOCK = '/@VmixFieldName\(\"(\w+)\"\)/m';

    /**
     * @param string $className
     * @return array
     * @throws ReflectionException
     */
    public static function hydrate($className)
    {
        // There is a reason this is done manual and not with Doctrine Annotations
        // Reduce Dependencies, Ensure backwards compatibility for PHP 5
        $reflectionClass = new \ReflectionClass($className);
        $classProperties = $reflectionClass->getProperties();

        $annotationData = [];
        foreach ($classProperties as $property) {
            $property->setAccessible(true);

            $docBlocks = $property->getDocComment();

            $match = [];

            if (0 === preg_match(static::REGEX_DOCBLOCK, $docBlocks, $match)) {
                continue;
            }

            $annotationData[$property->getName()] = $match[1];
        }

        return $annotationData;
    }
}
