<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\VmixSync\Converter;

use Psr\Http\Message\ResponseInterface;
use SimpleXMLElement;
use Vtours\VmixSync\Model\Response;

/**
 * Class ResponseConverter
 * @package Vtours\VmixSync\Converter
 */
class ResponseConverter
{
    const DATETIME_FORMAT = 'Y-m-d H:i:s';

    /**
     * @param string $curlResponse
     * @return Response
     */
    public static function convert($curlResponse)
    {
        $response = new Response();

        $xml = simplexml_load_string($curlResponse);

        $response
            ->setStatus((string)$xml->Status)
            ->setBookingId((integer)$xml->booking_no)
            ->setTimestamp(\DateTime::createFromFormat(static::DATETIME_FORMAT, $xml->Timestamp))
            ->setProcessStart(\DateTime::createFromFormat(static::DATETIME_FORMAT, $xml->ProcessStart))
            ->setProcessEnd(\DateTime::createFromFormat(static::DATETIME_FORMAT, $xml->ProcessEnd));

        if ('NOK' === $response->getStatus()) {
            $response->setErrors(
                static::processErrors($xml)
            );
        }

        return $response;
    }

    /**
     * @param SimpleXMLElement $xml
     * @return array
     */
    private static function processErrors($xml)
    {
        $errors = [];
        foreach ($xml->Errors->Item as $item) {
            $errors[] = (string)$item;
        }

        return $errors;
    }
}
