<?php
/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Converter;

use PHPUnit\Framework\TestCase;
use Vtours\VmixSync\Annotation\AnnotationHydrator;
use Vtours\VmixSync\Converter\VmixDataConverter;
use Vtours\VmixSync\Exception\VmixSyncException;
use Vtours\VmixSync\Model\VmixData;

/**
 * Class VmixDataConverterTest
 * @package Converter
 */
class VmixDataConverterTest extends TestCase
{
    public function test_vmix_data_conversion()
    {
        $annotationData = AnnotationHydrator::hydrate(VmixData::class);
        $vmixData = (new VmixData())
            ->setInternalComment('test')
            ->setPrePaymentDate(new \DateTime())
            ->setPrePaymentStatus(true);

        $ret = VmixDataConverter::convertToArray($vmixData, $annotationData);

        $dateTime = (new \DateTime())->format('Y-m-d');

        self::assertEquals('test', $ret['bemerkung']);
        self::assertEquals($dateTime, $ret['prepayment_date']);
        self::assertTrue($ret['prepayment_on']);
    }

    public function test_vmix_data_conversion_with_unsupported_object()
    {
        self::expectException(VmixSyncException::class);

        $annotationData = AnnotationHydrator::hydrate(VmixData::class);
        $vmixData = (new VmixData())
            ->setInternalComment(new VmixData())
            ->setPrePaymentStatus(true);

        $ret = VmixDataConverter::convertToArray($vmixData, $annotationData);
    }

    public function test_vmix_data_conversion_array_walk_break()
    {
        self::expectError();
        $annotationData = [new VmixData()];
        $vmixData = (new VmixData())->setInternalComment('test');

        $ret = VmixDataConverter::convertToArray($vmixData, $annotationData);
        var_dump($ret);
    }
}