<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\VmixSync\Converter;

use Vtours\VmixSync\Exception\VmixSyncException;
use Vtours\VmixSync\Model\VmixDataInterface;

/**
 * Class Mapper
 * @package Vtours\VmixSync\Mapper
 */
class VmixDataConverter
{
    /**
     * @param VmixDataInterface $vmixData
     * @param array $annotationData
     * @return array
     * @throws VmixSyncException
     */
    public static function convertToArray(VmixDataInterface $vmixData, array $annotationData)
    {
        $objectArray = array_filter($vmixData->asArray());

        $mappedArray = [];
        array_walk($objectArray, function ($value, &$key) use ($annotationData, &$mappedArray) {
            if ($value instanceof \DateTime) {
                $value = $value->format('Y-m-d');
            }

            if (is_object($value) || is_array($value)) {
                throw new VmixSyncException('Invalid data received during conversion: ' . print_r($value, true));
            }

            $mappedArray[$annotationData[$key]] = $value;

        });

        return $mappedArray;
    }
}
