<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\VmixSync\Model;

use ReflectionException;
use Vtours\VmixSync\Annotation\AnnotationHydrator;
use Vtours\VmixSync\Converter\VmixDataConverter;
use Vtours\VmixSync\Exception\VmixSyncException;

/**
 * Class VmixDataWrapper
 * @package Vtours\VmixSync\Model
 */
class Request
{
    /**
     * @var integer
     *
     */
    private $bookingId;

    /**
     * Concenation of Booking ID and a static string
     *
     * @var string
     */
    private $checkMd5;

    /**
     * @var VmixDataInterface
     */
    private $vmixData;

    /**
     * @return int
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }

    /**
     * @param int $bookingId
     * @return Request
     */
    public function setBookingId($bookingId)
    {
        $this->bookingId = $bookingId;
        return $this;
    }

    /**
     * @return string
     */
    public function getCheckMd5()
    {
        return $this->checkMd5;
    }

    /**
     * @param string $checkMd5
     * @return Request
     */
    public function setCheckMd5($checkMd5)
    {
        $this->checkMd5 = $checkMd5;
        return $this;
    }

    /**
     * @return VmixDataInterface
     */
    public function getVmixData()
    {
        return $this->vmixData;
    }

    /**
     * @param VmixDataInterface $vmixData
     * @return Request
     */
    public function setVmixData($vmixData)
    {
        $this->vmixData = $vmixData;
        return $this;
    }

    /**
     * @return array
     * @throws ReflectionException
     * @throws VmixSyncException
     */
    public function asArray()
    {
        $annotations = AnnotationHydrator::hydrate(get_class($this->vmixData));

        return array(
            "booking_no" => $this->bookingId,
            "chck" => md5($this->checkMd5),
            "VmixData" => VmixDataConverter::convertToArray($this->vmixData, $annotations)
        );
    }
}
