<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

/**
 * Interface HandlerInterface
 *
 * @package Vtours\Website\Mapper
 */
interface HandlerInterface
{

    /**
     * Is the handler capable of handling this input
     *
     * @param mixed $object
     *
     * @return boolean
     */
    public function handles($object);

    /**
     * Execute actual handling of given input
     *
     * @param mixed  $object
     *
     * @param string $language
     *
     * @return mixed
     */
    public function handle($object, $language);
}
