<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneFooterInfoleiste;
use Vtours\Website\Model\Stage\Element\TitleText;
use Vtours\Website\Model\Stage\FooterVersprechen;

/**
 * Class StageFooterInformationBar
 *
 * @package Vtours\Website\Mapper
 */
class StageFooterInformationBar implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneFooterInfoleiste;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        return (new FooterVersprechen())
            ->setObjectId($object->getId())
            ->setElement1(
                (new TitleText())
                    ->setTitle($object->getTitle1($language))
                    ->setContent($object->getText1($language))
            )->setElement2(
                (new TitleText())
                    ->setTitle($object->getTitle2($language))
                    ->setContent($object->getText2($language))
            )->setElement3(
                (new TitleText())
                    ->setTitle($object->getTitle3($language))
                    ->setContent($object->getText3($language))
            )->setElement4(
                (new TitleText())
                    ->setTitle($object->getTitle4($language))
                    ->setContent($object->getText4($language))
            );
    }
}
