<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneReisezieleListeKarte;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;
use Vtours\Website\Model\Stage\ReisezieleListeKarte;

/**
 * Class StageReisezieleListeKarte
 *
 * @package Vtours\Website\Mapper
 */
class StageReisezieleListeKarte implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneReisezieleListeKarte;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $elements = $object->getEnumeration($language);

        $linkElements = [];
        foreach ($elements as $element) {

            /**
             * @var \Pimcore\Model\Object\Data\Link $link
             */
            $link = $element['link']->getData();

            $linkElements[] = (new Link())
                ->setText($link->getText())
                ->setTitle($link->getTitle())
                ->setHref($link->getHref())
                ->setTarget($link->getTarget());
        }

        $image = (new Image())->build($object->getPicture($language), $language);

        return (new ReisezieleListeKarte())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle($language))
            ->setEnumerationTitle($object->getEnumerationTitle($language))
            ->setEnumeration($linkElements)
            ->setMapPicture($image)
            ->setTextLeft($object->getTextLeft($language))
            ->setTextRight($object->getTextRight($language));
    }
}
