<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneService;
use Pimcore\Model\Object\VtoursNavi;
use Vtours\Website\Model\Navigation\Route;
use Vtours\Website\Model\Stage\Element\ServiceArea;
use Vtours\Website\Model\Stage\Service;

/**
 * Class StageService
 *
 * @package Vtours\Website\Mapper
 */
class StageService implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneService;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $serviceAreas = $object->getServiceArea();

        $services = [];
        foreach ($serviceAreas as $serviceArea) {

            $routes = $serviceArea['pages']->getData();
            $routeArray = [];

            /**
             * @var VtoursNavi $route
             */
            foreach ($routes as $route) {

                if ($route->isPublished()) {
                    $path = str_replace(Route::STRIP_PATH, '', $route->getFullPath()) . '/';

                    $routeArray[] = (new Route())
                        ->setRouteId($route->getId())
                        ->setName($route->getKey())
                        ->setLinkName($route->getLinkName())
                        ->setPath($path);
                }
            }

            $services[] = (new ServiceArea())
                ->setServiceIcon($serviceArea['serviceIcon']->getData())
                ->setServiceTitle($serviceArea['serviceTitle']->getData())
                ->setRoutes($routeArray);
        }

        return (new Service())
            ->setObjectId($object->getId())
            ->setHeadline($object->getHeadline())
            ->setSubHeadline($object->getSubHeadline())
            ->setServiceArea($services);
    }
}
