<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;

/**
 * Class Countdown
 *
 * @package Vtours\Website\Model\Stage
 */
class Countdown extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'countdown.twig';

    /**
     * @var string
     */
    private $title;

    /**
     * @var \DateTime
     */
    private $endTime;

    /**
     * @var bool
     */
    private $firstOfferHighlighted;

    /**
     * @var Angebot[]
     */
    private $offer;

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Countdown
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->endTime;
    }

    /**
     * @param \DateTime $endTime
     *
     * @return Countdown
     */
    public function setEndTime($endTime)
    {
        $this->endTime = $endTime;

        return $this;
    }

    /**
     * @return bool
     */
    public function isFirstOfferHighlighted()
    {
        return $this->firstOfferHighlighted;
    }

    /**
     * @param bool $firstOfferHighlighted
     *
     * @return Countdown
     */
    public function setFirstOfferHighlighted($firstOfferHighlighted)
    {
        $this->firstOfferHighlighted = $firstOfferHighlighted;

        return $this;
    }

    /**
     * @return Angebot[]
     */
    public function getOffer()
    {
        return $this->offer;
    }

    /**
     * @param Angebot[] $offer
     *
     * @return Countdown
     */
    public function setOffer($offer)
    {
        $this->offer = $offer;

        return $this;
    }
}
