<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage\Element;

use Vtours\Website\Model\Navigation\Route;

/**
 * Class ServiceArea
 *
 * @package Vtours\Website\Model\Stage\Element
 */
class ServiceArea
{

    /**
     * @var string
     */
    private $serviceIcon;

    /**
     * @var string
     */
    private $serviceTitle;

    /**
     * @var Route[]
     */
    private $routes;

    /**
     * @return string
     */
    public function getServiceIcon()
    {
        return $this->serviceIcon;
    }

    /**
     * @param string $serviceIcon
     *
     * @return ServiceArea
     */
    public function setServiceIcon($serviceIcon)
    {
        $this->serviceIcon = $serviceIcon;

        return $this;
    }

    /**
     * @return string
     */
    public function getServiceTitle()
    {
        return $this->serviceTitle;
    }

    /**
     * @param string $serviceTitle
     *
     * @return ServiceArea
     */
    public function setServiceTitle($serviceTitle)
    {
        $this->serviceTitle = $serviceTitle;

        return $this;
    }

    /**
     * @return Route[]
     */
    public function getRoutes()
    {
        return $this->routes;
    }

    /**
     * @param Route[] $routes
     *
     * @return ServiceArea
     */
    public function setRoutes($routes)
    {
        $this->routes = $routes;

        return $this;
    }
}
