<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;

/**
 * Class Hero
 *
 * @package Vtours\Website\Model\Stage
 */
class Hero extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'hero.twig';

    /**
     * @var Image
     */
    private $backgroundPictureXS;

    /**
     * @var Image
     */
    private $backgroundPictureSM;

    /**
     * @var Image
     */
    private $backgroundPictureMD;

    /**
     * @var Image
     */
    private $backgroundPictureLG;

    /**
     * @var Angebot
     */
    private $offer;

    /**
     * @return Image
     */
    public function getBackgroundPictureXS()
    {
        return $this->backgroundPictureXS;
    }

    /**
     * @param Image $backgroundPictureXS
     *
     * @return Hero
     */
    public function setBackgroundPictureXS($backgroundPictureXS)
    {
        $this->backgroundPictureXS = $backgroundPictureXS;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureSM()
    {
        return $this->backgroundPictureSM;
    }

    /**
     * @param Image $backgroundPictureSM
     *
     * @return Hero
     */
    public function setBackgroundPictureSM($backgroundPictureSM)
    {
        $this->backgroundPictureSM = $backgroundPictureSM;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureMD()
    {
        return $this->backgroundPictureMD;
    }

    /**
     * @param Image $backgroundPictureMD
     *
     * @return Hero
     */
    public function setBackgroundPictureMD($backgroundPictureMD)
    {
        $this->backgroundPictureMD = $backgroundPictureMD;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureLG()
    {
        return $this->backgroundPictureLG;
    }

    /**
     * @param Image $backgroundPictureLG
     *
     * @return Hero
     */
    public function setBackgroundPictureLG($backgroundPictureLG)
    {
        $this->backgroundPictureLG = $backgroundPictureLG;

        return $this;
    }

    /**
     * getBackgroundPicture
     *
     * @param string $size
     *
     * @return Image
     */
    public function getBackgroundPicture($size)
    {
        $size = strtolower($size);

        $picture = $this->backgroundPictureLG;

        if ($size == 'md' && !empty($this->backgroundPictureMD->getUrl())) {
            $picture = (empty($this->backgroundPictureMD->getUrl()) ? $this->backgroundPictureLG : $this->backgroundPictureMD);
        }

        if ($size == 'sm') {
            if (!empty($this->backgroundPictureSM->getUrl())) {
                $picture = $this->backgroundPictureSM;
            } elseif (!empty($this->backgroundPictureMD->getUrl())) {
                $picture = $this->backgroundPictureMD;
            }
        }

        if ($size == 'xs') {
            if (!empty($this->backgroundPictureXS->getUrl())) {
                $picture = $this->backgroundPictureXS;
            } elseif (!empty($this->backgroundPictureSM->getUrl())) {
                $picture = $this->backgroundPictureSM;
            } elseif (!empty($this->backgroundPictureMD->getUrl())) {
                $picture = $this->backgroundPictureMD;
            }
        }

        return $picture;
    }

    /**
     * @return Angebot
     */
    public function getOffer()
    {
        return $this->offer;
    }

    /**
     * @param Angebot $offer
     *
     * @return Hero
     */
    public function setOffer($offer)
    {
        $this->offer = $offer;

        return $this;
    }


}
