<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\InspirationBlock;

/**
 * Class Inspiration
 *
 * @package Vtours\Website\Model\Stage
 */
class Inspiration extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'inspiration.twig';

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $showMore;

    /**
     * @var InspirationBlock
     */
    private $elements;


    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Inspiration
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getShowMore()
    {
        return $this->showMore;
    }

    /**
     * @param mixed $showMore
     *
     * @return Inspiration
     */
    public function setShowMore($showMore)
    {
        $this->showMore = $showMore;

        return $this;
    }

    /**
     * @return InspirationBlock
     */
    public function getElements()
    {
        return $this->elements;
    }

    /**
     * @param InspirationBlock $elements
     *
     * @return Inspiration
     */
    public function setElements($elements)
    {
        $this->elements = $elements;

        return $this;
    }
}
