<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\ServiceArea;

class Service extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'service.twig';

    /**
     * @var string
     */
    private $headline;

    /**
     * @var string
     */
    private $subHeadline;

    /**
     * @var ServiceArea[]
     */
    private $serviceArea;

    /**
     * @return string
     */
    public function getHeadline()
    {
        return $this->headline;
    }

    /**
     * @param string $headline
     *
     * @return Service
     */
    public function setHeadline($headline)
    {
        $this->headline = $headline;

        return $this;
    }

    /**
     * @return string
     */
    public function getSubHeadline()
    {
        return $this->subHeadline;
    }

    /**
     * @param string $subHeadline
     *
     * @return Service
     */
    public function setSubHeadline($subHeadline)
    {
        $this->subHeadline = $subHeadline;

        return $this;
    }

    /**
     * @return ServiceArea[]
     */
    public function getServiceArea()
    {
        return $this->serviceArea;
    }

    /**
     * @param ServiceArea[] $serviceArea
     *
     * @return Service
     */
    public function setServiceArea($serviceArea)
    {
        $this->serviceArea = $serviceArea;

        return $this;
    }
}
