<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\TitleText;

/**
 * Class VfamilyAngebote
 *
 * @package Vtours\Website\Model\Stage
 */
class VfamilyAngebote extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'vfamily-angebote.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $content;

    /**
     * @var string
     */
    private $pictureLocation;

    /**
     * @var Image
     */
    private $picture;

    /**
     * @var string
     */
    private $offersTitle;

    /**
     * @var TitleText[]
     */
    private $offers;


    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return VfamilyAngebote
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;

        return $this;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param string $content
     *
     * @return VfamilyAngebote
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * @return string
     */
    public function getPictureLocation()
    {
        return $this->pictureLocation;
    }

    /**
     * @param string $pictureLocation
     *
     * @return VfamilyAngebote
     */
    public function setPictureLocation($pictureLocation)
    {
        $this->pictureLocation = $pictureLocation;

        return $this;
    }

    /**
     * @return Image
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * @param Image $picture
     *
     * @return VfamilyAngebote
     */
    public function setPicture($picture)
    {
        $this->picture = $picture;

        return $this;
    }

    /**
     * @return string
     */
    public function getOffersTitle()
    {
        return $this->offersTitle;
    }

    /**
     * @param string $offersTitle
     *
     * @return VfamilyAngebote
     */
    public function setOffersTitle($offersTitle)
    {
        $this->offersTitle = $offersTitle;

        return $this;
    }

    /**
     * @return TitleText[]
     */
    public function getOffers()
    {
        return $this->offers;
    }

    /**
     * @param TitleText[] $offers
     *
     * @return VfamilyAngebote
     */
    public function setOffers($offers)
    {
        $this->offers = $offers;

        return $this;
    }
}
