<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneHero;
use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Hero;

/**
 * Class StageHero
 *
 * @package Vtours\Website\Mapper
 */
class StageHero implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneHero;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $pictureXS = new Image();
        if (!empty($object->getBackgroundPictureXS($language))) {
            $pictureXS->build($object->getBackgroundPictureXS($language), $language);
        }

        $pictureSM = new Image();
        if (!empty($object->getBackgroundPictureSM($language))) {
            $pictureSM->build($object->getBackgroundPictureSM($language), $language);
        }

        $pictureMD = new Image();
        if (!empty($object->getBackgroundPictureMD($language))) {
            $pictureMD->build($object->getBackgroundPictureMD($language), $language);
        }

        $pictureLG = new Image();
        if (!empty($object->getBackgroundPictureLG($language))) {
            $pictureLG->build($object->getBackgroundPictureLG($language), $language);
        }

        $offer = new Angebot();
        if (!empty($object->getOffer())) {

            $offerPimcore = $object->getOffer();

            $offer->setHotelName($offerPimcore->getHotelName())
                ->setLocation($offerPimcore->getLocation())
                ->setCountry($offerPimcore->getCountry())
                ->setCategory($offerPimcore->getCategory())
                ->setMaxTemperature($offerPimcore->getMaxTemperature()->getValue())
                ->setPrice($offerPimcore->getPrice())
                ->setMeal($offerPimcore->getMeal())
                ->setRoomType($offerPimcore->getRoomType())
                ->setDuration($offerPimcore->getDuration())
                ->setFlight($offerPimcore->getFlight())
                ->setTransfer($offerPimcore->getTransfer())
                ->setDeepLink($offerPimcore->getDeepLink())
                ->setPriceCustom($offerPimcore->getPriceCustom())
                ->setLimitedOffer($offerPimcore->getLimitedOffer())
                ->setTip($offerPimcore->getTipp())
                ->setVFamily($offerPimcore->getVFamily())
                ->setBigOffer($offerPimcore->getBigOffer());
        }

        return (new Hero())
            ->setObjectId($object->getId())
            ->setBackgroundPictureXS($pictureXS)
            ->setBackgroundPictureSM($pictureSM)
            ->setBackgroundPictureMD($pictureMD)
            ->setBackgroundPictureLG($pictureLG)
            ->setOffer($offer);
    }
}
