<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneInspiration;
use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\InspirationBig;
use Vtours\Website\Model\Stage\Element\InspirationBlock;
use Vtours\Website\Model\Stage\Element\InspirationSmall;
use Vtours\Website\Model\Stage\Inspiration;

/**
 * Class StageInspiration
 *
 * @package Vtours\Website\Mapper
 */
class StageInspiration implements HandlerInterface
{
    /**
     * @param VtoursBuehneInspiration $object
     *
     * @return bool
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneInspiration;
    }

    /**
     * @param VtoursBuehneInspiration $object
     * @param string                  $language
     *
     * @return Inspiration
     */
    public function handle($object, $language)
    {
        $inspiration = new Inspiration();

        $inspiration->setObjectId($object->getId());

        $inspiration
            ->setTitle($object->getTitle())
            ->setShowMore($object->getShowMore());

        $inspirationBlock = new InspirationBlock();

        // elements for small Offers
        $inspirationObjectSmall = $object->getInspirationSmall();

        $inspirationSmallArray = [];
        foreach ($inspirationObjectSmall as $small) {
            $elementSmall = new InspirationSmall();
            $elementSmall->setLink($small->getLink());

            $picture = (new Image())->build($small->getPicture(), $language);
            $elementSmall->setPicture($picture);

            $angebot = new Angebot();
            $offer = $small->getOffer();
            $angebot->setHotelName($offer->getHotelName())
                ->setCountry($offer->getCountry())
                ->setLocation($offer->getLocation())
                ->setCategory($offer->getCategory())
                ->setMaxTemperature($offer->getMaxTemperature())
                ->setMeal($offer->getMeal())
                ->setRoomType($offer->getRoomType())
                ->setDuration($offer->getDuration())
                ->setFlight($offer->getFlight())
                ->setTransfer($offer->getTransfer())
                ->setPrice($offer->getPrice())
                ->setPriceCustom($offer->getPriceCustom())
                ->setTip($offer->getTipp())
                ->setVFamily($offer->getVfamily())
                ->setLimitedOffer($offer->getLimited())
                ->setBigOffer($offer->getBigOffer());

            $image = (new Image())->build($offer->getImage(), $language);
            $angebot->setPicture($image);

            $hotelPicture = (new Image())->build($offer->getHotelPicture(), $language);
            $angebot->setHotelPicture($hotelPicture);

            $elementSmall->setOffer($angebot);
            $inspirationSmallArray = $elementSmall;
        }
        $inspirationBlock->setInspirationSmall($inspirationSmallArray);

        // elements for big Offers
        $inspirationObjectBig = $object->getInspirationBig();

        $inspirationBigArray = [];
        foreach ($inspirationObjectBig as $big) {
            $elementBig = new InspirationBig();
            $elementBig->setLink($big->getLink());

            $picture = (new Image())->build($big->getPicture(), $language);
            $elementBig->setPicture($picture);

            $angebot = new Angebot();
            $offer = $big->getOffer();
            $angebot->setHotelName($offer->getHotelName())
                ->setCountry($offer->getCountry())
                ->setLocation($offer->getLocation())
                ->setCategory($offer->getCategory())
                ->setMaxTemperature($offer->getMaxTemperature())
                ->setMeal($offer->getMeal())
                ->setRoomType($offer->getRoomType())
                ->setDuration($offer->getDuration())
                ->setFlight($offer->getFlight())
                ->setTransfer($offer->getTransfer())
                ->setPrice($offer->getPrice())
                ->setPriceCustom($offer->getPriceCustom())
                ->setTip($offer->getTipp())
                ->setVFamily($offer->getVfamily())
                ->setLimitedOffer($offer->getLimited())
                ->setBigOffer($offer->getBigOffer());

            $image = (new Image())->build($offer->getImage(), $language);
            $angebot->setPicture($image);

            $hotelPicture = (new Image())->build($offer->getHotelPicture(), $language);
            $angebot->setHotelPicture($hotelPicture);

            $elementBig->setOffer($angebot);
            $inspirationBigArray[] = $elementBig;
        }
        $inspirationBlock->setInspirationBig($inspirationBigArray);

        $inspiration->setElements($inspirationBlock);

        return $inspiration;
    }
}
